/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.apple2e.RAM128k;
import jace.apple2e.SoftSwitches;
import jace.core.Computer;
import jace.core.Font;
import jace.core.Palette;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import jace.core.Video;
import jace.core.VideoWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.logging.Logger;

public class VideoDHGR
extends Video {
    public static final int[] flipNybble;
    private static boolean USE_GS_MOUSETEXT;
    private VideoWriter textPage1;
    private VideoWriter textPage2;
    private VideoWriter loresPage1;
    private VideoWriter loresPage2;
    private VideoWriter hiresPage1;
    private VideoWriter hiresPage2;
    private VideoWriter text80Page1;
    private VideoWriter text80Page2;
    private VideoWriter dloresPage1;
    private VideoWriter dloresPage2;
    private VideoWriter dhiresPage1;
    private VideoWriter dhiresPage2;
    private VideoWriter mixed;
    protected RAM128k memory;
    private VideoWriter currentGraphicsWriter = null;
    private VideoWriter currentTextWriter = null;
    boolean extraHalfBit = false;
    static final int[][] hgrToDhgr;
    static final int[][] hgrToDhgrBW;
    static final int[] times14;
    static final int[] flipBits;
    boolean flashInverse = false;
    int flashTimer = 0;
    int FLASH_SPEED = 16;
    int[] currentCharMap = CHAR_MAP1;
    static final int[] CHAR_MAP1;
    static final int[] CHAR_MAP2;
    static final int[] CHAR_MAP3;
    protected boolean hiresMode = false;
    static final int BLACK;
    static final int WHITE;
    static final int[][] xyOffset;

    public VideoDHGR() {
        this.memory = (RAM128k)Computer.getComputer().getMemory();
        this.hiresPage1 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayHires(screen, xOffset, y, yGraphicsOffset + 8192);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 8192);
            }
        };
        this.hiresPage2 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayHires(screen, xOffset, y, yGraphicsOffset + 16384);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 16384);
            }
        };
        this.dhiresPage1 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayDoubleHires(screen, xOffset, y, yGraphicsOffset + 8192);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 8192);
            }

            @Override
            public boolean isRowDirty(int y) {
                return VideoDHGR.this.hiresPage1.isRowDirty(y);
            }
        };
        this.dhiresPage2 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayDoubleHires(screen, xOffset, y, yGraphicsOffset + 16384);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 16384);
            }

            @Override
            public boolean isRowDirty(int y) {
                return VideoDHGR.this.hiresPage2.isRowDirty(y);
            }
        };
        this.textPage1 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayText(screen, xOffset, y, yTextOffset + 1024);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 1024);
            }
        };
        this.textPage2 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayText(screen, xOffset, y, yTextOffset + 2048);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 2048);
            }
        };
        this.text80Page1 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayText80(screen, xOffset, y, yTextOffset + 1024);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 1024);
            }
        };
        this.text80Page2 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayText80(screen, xOffset, y, yTextOffset + 2048);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 2048);
            }
        };
        this.loresPage1 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayLores(screen, xOffset, y, yTextOffset + 1024);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 1024);
            }

            @Override
            public int getWaitCycles() {
                return 1;
            }
        };
        this.loresPage2 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayLores(screen, xOffset, y, yTextOffset + 2048);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 2048);
            }

            @Override
            public int getWaitCycles() {
                return 0;
            }
        };
        this.dloresPage1 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayDoubleLores(screen, xOffset, y, yTextOffset + 1024);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 1024);
            }

            @Override
            public int getWaitCycles() {
                return 0;
            }
        };
        this.dloresPage2 = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayDoubleLores(screen, xOffset, y, yTextOffset + 2048);
                VideoDHGR.this.setScannerLocation(yGraphicsOffset + 2048);
            }

            @Override
            public int getWaitCycles() {
                return 0;
            }
        };
        this.mixed = new VideoWriter(){

            @Override
            public void displayByte(BufferedImage screen, int xOffset, int y, int yTextOffset, int yGraphicsOffset) {
                VideoDHGR.this.displayMixed(screen, xOffset, y, yTextOffset, yGraphicsOffset);
            }

            @Override
            public VideoWriter actualWriter() {
                if (VideoDHGR.this.y < 160) {
                    return VideoDHGR.this.currentGraphicsWriter;
                }
                return VideoDHGR.this.currentTextWriter;
            }

            @Override
            public int getWaitCycles() {
                return this.actualWriter().getWaitCycles();
            }
        };
        this.registerDirtyFlagChecks();
    }

    protected void displayDoubleHires(BufferedImage screen, int xOffset, int y, int rowAddress) {
        byte b1 = this.memory.auxMemory.readByte(rowAddress + xOffset);
        byte b2 = this.memory.mainMemory.readByte(rowAddress + xOffset);
        byte b3 = this.memory.auxMemory.readByte(rowAddress + xOffset + 1);
        byte b4 = this.memory.mainMemory.readByte(rowAddress + xOffset + 1);
        int dhgrWord = 0x7F & b1;
        dhgrWord |= (0x7F & b2) << 7;
        dhgrWord |= (0x7F & b3) << 14;
        this.setFloatingBus(b4);
        this.showDhgr(screen, times14[xOffset], y, dhgrWord |= (0x7F & b4) << 21);
    }

    protected void displayHires(BufferedImage screen, int xOffset, int y, int rowAddress) {
        int b1 = 0xFF & this.memory.mainMemory.readByte(rowAddress + xOffset);
        int b2 = 0xFF & this.memory.mainMemory.readByte(rowAddress + xOffset + 1);
        this.setFloatingBus((byte)b2);
        int dhgrWord = hgrToDhgr[this.extraHalfBit ? b1 | 0x100 : b1][b2];
        this.extraHalfBit = dhgrWord >= 0x8000000 && xOffset < 38;
        this.showDhgr(screen, times14[xOffset], y, dhgrWord);
    }

    protected void displayLores(BufferedImage screen, int xOffset, int y, int rowAddress) {
        int c1 = this.memory.mainMemory.readByte(rowAddress + xOffset) & 0xFF;
        this.setFloatingBus((byte)c1);
        c1 = (y & 7) < 4 ? (c1 &= 0xF) : (c1 >>= 4);
        DataBuffer b = screen.getRaster().getDataBuffer();
        int yOffset = xyOffset[y][times14[xOffset]];
        int color = Palette.color[c1].getRGB();
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
    }

    private void displayDoubleLores(BufferedImage screen, int xOffset, int y, int rowAddress) {
        int c1 = this.memory.auxMemory.readByte(rowAddress + xOffset) & 0xFF;
        int c2 = this.memory.mainMemory.readByte(rowAddress + xOffset) & 0xFF;
        this.setFloatingBus((byte)c2);
        if ((y & 7) < 4) {
            c1 &= 0xF;
            c2 &= 0xF;
        } else {
            c1 >>= 4;
            c2 >>= 4;
        }
        DataBuffer b = screen.getRaster().getDataBuffer();
        int yOffset = xyOffset[y][times14[xOffset]];
        int color = Palette.color[c1].getRGB();
        int color2 = Palette.color[c2].getRGB();
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color);
        b.setElem(yOffset++, color2);
        b.setElem(yOffset++, color2);
        b.setElem(yOffset++, color2);
        b.setElem(yOffset++, color2);
        b.setElem(yOffset++, color2);
        b.setElem(yOffset++, color2);
        b.setElem(yOffset++, color2);
    }

    @Override
    protected void vblankStart() {
        this.setFloatingBus((byte)0);
        if (SoftSwitches.ALTCH.isOn()) {
            this.currentCharMap = CHAR_MAP3;
        } else {
            --this.flashTimer;
            if (this.flashTimer <= 0) {
                this.markFlashDirtyBits();
                this.flashTimer = this.FLASH_SPEED;
                this.flashInverse = !this.flashInverse;
                this.currentCharMap = this.flashInverse ? CHAR_MAP2 : CHAR_MAP1;
            }
        }
    }

    @Override
    protected void vblankEnd() {
    }

    private int getFontChar(byte b) {
        return this.currentCharMap[b & 0xFF];
    }

    protected void displayText(BufferedImage screen, int xOffset, int y, int rowAddress) {
        int yOffset = y & 7;
        byte byte2 = this.memory.mainMemory.readByte(rowAddress + xOffset + 1);
        this.setFloatingBus(byte2);
        int c1 = this.getFontChar(this.memory.mainMemory.readByte(rowAddress + xOffset));
        int c2 = this.getFontChar(byte2);
        int b1 = Font.getByte(c1, yOffset);
        int b2 = Font.getByte(c2, yOffset);
        int out = hgrToDhgrBW[b1][b2];
        this.showBW(screen, times14[xOffset], y, out);
    }

    protected void displayText80(BufferedImage screen, int xOffset, int y, int rowAddress) {
        int yOffset = y & 7;
        int c1 = this.getFontChar(this.memory.auxMemory.readByte(rowAddress + xOffset));
        int c2 = this.getFontChar(this.memory.mainMemory.readByte(rowAddress + xOffset));
        int c3 = this.getFontChar(this.memory.auxMemory.readByte(rowAddress + xOffset + 1));
        int c4 = this.getFontChar(this.memory.mainMemory.readByte(rowAddress + xOffset + 1));
        this.setFloatingBus((byte)c4);
        int bits = Font.getByte(c1, yOffset) | Font.getByte(c2, yOffset) << 7 | Font.getByte(c3, yOffset) << 14 | Font.getByte(c4, yOffset) << 21;
        this.showBW(screen, times14[xOffset], y, bits);
    }

    private void displayMixed(BufferedImage screen, int xOffset, int y, int textOffset, int graphicsOffset) {
        this.mixed.actualWriter().displayByte(screen, xOffset, y, textOffset, graphicsOffset);
    }

    @Override
    public void configureVideoMode() {
        boolean page2;
        boolean bl = page2 = SoftSwitches.PAGE2.isOn() && SoftSwitches._80STORE.isOff();
        VideoWriter videoWriter = SoftSwitches._80COL.getState() ? (page2 ? this.text80Page2 : this.text80Page1) : (this.currentTextWriter = page2 ? this.textPage2 : this.textPage1);
        VideoWriter videoWriter2 = SoftSwitches._80COL.getState() && SoftSwitches.DHIRES.getState() ? (SoftSwitches.HIRES.getState() ? (page2 ? this.dhiresPage2 : this.dhiresPage1) : (page2 ? this.dloresPage2 : this.dloresPage1)) : (SoftSwitches.HIRES.getState() ? (page2 ? this.hiresPage2 : this.hiresPage1) : (this.currentGraphicsWriter = page2 ? this.loresPage2 : this.loresPage1));
        this.setCurrentWriter(SoftSwitches.TEXT.getState() ? this.currentTextWriter : (SoftSwitches.MIXED.getState() ? this.mixed : this.currentGraphicsWriter));
        this.hiresMode = SoftSwitches.DHIRES.getState();
    }

    protected void showDhgr(BufferedImage screen, int xOffset, int y, int dhgrWord) {
        DataBuffer b = screen.getRaster().getDataBuffer();
        int yOffset = xyOffset[y][xOffset];
        try {
            for (int i = 0; i < 7; ++i) {
                int color = Palette.color[flipNybble[dhgrWord & 0xF]].getRGB();
                b.setElem(yOffset++, color);
                b.setElem(yOffset++, color);
                b.setElem(yOffset++, color);
                b.setElem(yOffset++, color);
                dhgrWord >>= 4;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Logger.getLogger(this.getClass().getName()).warning("Went out of bounds in video display");
        }
    }

    protected void showBW(BufferedImage screen, int xOffset, int y, int dhgrWord) {
        boolean color = false;
        DataBuffer b = screen.getRaster().getDataBuffer();
        int yOffset = xyOffset[y][xOffset];
        for (int i = 0; i < 28; ++i) {
            b.setElem(yOffset++, (dhgrWord & 1) == 1 ? WHITE : BLACK);
            dhgrWord >>= 1;
        }
    }

    @Override
    public void doPostDraw() {
    }

    @Override
    protected String getDeviceName() {
        return "DHGR-Capable Video";
    }

    private void markFlashDirtyBits() {
        for (int row = 0; row < 192; ++row) {
            this.currentTextWriter.markDirty(row);
        }
    }

    private void registerDirtyFlagChecks() {
        this.memory.addListener(new RAMListener(RAMEvent.TYPE.WRITE, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(1024);
                this.setScopeEnd(3071);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                int row = textRowLookup[e.getAddress() & 0x3FF];
                if (row > 23) {
                    return;
                }
                VideoWriter tmark = e.getAddress() < 2048 ? VideoDHGR.this.textPage1 : VideoDHGR.this.textPage2;
                VideoWriter gmark = e.getAddress() < 2048 ? VideoDHGR.this.loresPage1 : VideoDHGR.this.loresPage2;
                VideoWriter g80mark = e.getAddress() < 2048 ? VideoDHGR.this.dloresPage1 : VideoDHGR.this.dloresPage2;
                VideoWriter c80mark = e.getAddress() < 2048 ? VideoDHGR.this.text80Page1 : VideoDHGR.this.text80Page2;
                int yy = (row <<= 3) + 8;
                for (int y = row; y < yy; ++y) {
                    tmark.markDirty(y);
                    gmark.markDirty(y);
                    g80mark.markDirty(y);
                    c80mark.markDirty(y);
                }
            }
        });
        this.memory.addListener(new RAMListener(RAMEvent.TYPE.WRITE, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(8192);
                this.setScopeEnd(24575);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                int row = hiresRowLookup[e.getAddress() & 0x1FFF];
                if (row < 0 || row >= 192) {
                    return;
                }
                VideoWriter mark = e.getAddress() < 16384 ? VideoDHGR.this.hiresPage1 : VideoDHGR.this.hiresPage2;
                mark.markDirty(row);
            }
        });
    }

    @Override
    public void reconfigure() {
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public void hblankStart(BufferedImage screen, int y, boolean isDirty) {
    }

    static {
        int i;
        flipNybble = new int[]{0, 2, 4, 6, 8, 10, 12, 14, 1, 3, 5, 7, 9, 11, 13, 15};
        USE_GS_MOUSETEXT = false;
        flipBits = new int[256];
        for (i = 0; i < 256; ++i) {
            VideoDHGR.flipBits[i] = (i * 2050 & 0x22110 | i * 32800 & 0x88440) * 65793 >> 16 & 0xFF;
        }
        times14 = new int[40];
        for (i = 0; i < 40; ++i) {
            VideoDHGR.times14[i] = i * 14;
        }
        hgrToDhgr = new int[512][256];
        hgrToDhgrBW = new int[256][256];
        for (int bb1 = 0; bb1 < 512; ++bb1) {
            for (int bb2 = 0; bb2 < 256; ++bb2) {
                int b1 = VideoDHGR.byteDoubler((byte)(bb1 & 0x7F));
                if ((bb1 & 0x80) != 0) {
                    b1 <<= 1;
                }
                int b2 = VideoDHGR.byteDoubler((byte)(bb2 & 0x7F));
                if ((bb2 & 0x80) != 0) {
                    b2 <<= 1;
                }
                VideoDHGR.hgrToDhgr[bb1][bb2] = b1 | b2 << 14;
                VideoDHGR.hgrToDhgrBW[bb1 & 0xFF][bb2] = VideoDHGR.byteDoubler((byte)bb1) | VideoDHGR.byteDoubler((byte)bb2) << 14;
            }
        }
        CHAR_MAP1 = new int[256];
        CHAR_MAP2 = new int[256];
        CHAR_MAP3 = new int[256];
        for (int b = 0; b < 256; ++b) {
            int mod = b % 32;
            if (b < 32) {
                VideoDHGR.CHAR_MAP1[b] = mod + 192;
                VideoDHGR.CHAR_MAP2[b] = mod + 192;
                VideoDHGR.CHAR_MAP3[b] = mod + 192;
                continue;
            }
            if (b < 64) {
                VideoDHGR.CHAR_MAP1[b] = mod + 160;
                VideoDHGR.CHAR_MAP2[b] = mod + 160;
                VideoDHGR.CHAR_MAP3[b] = mod + 160;
                continue;
            }
            if (b < 96) {
                VideoDHGR.CHAR_MAP1[b] = mod + 192;
                VideoDHGR.CHAR_MAP2[b] = mod + 64;
                if (!USE_GS_MOUSETEXT && mod == 6) {
                    VideoDHGR.CHAR_MAP3[b] = 17;
                    continue;
                }
                if (!USE_GS_MOUSETEXT && mod == 7) {
                    VideoDHGR.CHAR_MAP3[b] = 18;
                    continue;
                }
                VideoDHGR.CHAR_MAP3[b] = mod + 128;
                continue;
            }
            if (b < 128) {
                VideoDHGR.CHAR_MAP1[b] = mod + 160;
                VideoDHGR.CHAR_MAP2[b] = mod + 32;
                VideoDHGR.CHAR_MAP3[b] = mod + 224;
                continue;
            }
            if (b < 160) {
                VideoDHGR.CHAR_MAP1[b] = mod + 64;
                VideoDHGR.CHAR_MAP2[b] = mod + 64;
                VideoDHGR.CHAR_MAP3[b] = mod + 64;
                continue;
            }
            if (b < 192) {
                VideoDHGR.CHAR_MAP1[b] = mod + 32;
                VideoDHGR.CHAR_MAP2[b] = mod + 32;
                VideoDHGR.CHAR_MAP3[b] = mod + 32;
                continue;
            }
            if (b < 224) {
                VideoDHGR.CHAR_MAP1[b] = mod + 64;
                VideoDHGR.CHAR_MAP2[b] = mod + 64;
                VideoDHGR.CHAR_MAP3[b] = mod + 64;
                continue;
            }
            VideoDHGR.CHAR_MAP1[b] = mod + 96;
            VideoDHGR.CHAR_MAP2[b] = mod + 96;
            VideoDHGR.CHAR_MAP3[b] = mod + 96;
        }
        BLACK = Color.BLACK.getRGB();
        WHITE = Color.WHITE.getRGB();
        xyOffset = new int[192][560];
        for (int y = 0; y < 192; ++y) {
            for (int x = 0; x < 560; ++x) {
                VideoDHGR.xyOffset[y][x] = y * 560 + x;
            }
        }
    }
}

